---
title : Examen
---

> Bienvenue dans le monde dangereux et difficile des désamorceurs de bombes.
>
> <cite>Keep Talking And Nobody Explodes</cite>

**Ce sujet constitue l'évaluation de fin du cours de Test.** Les documents de cours et l’utilisation de documentations officielles (_i.e._ [PHPUnit](https://phpunit.readthedocs.io/fr/latest/index.html) et [php.net](https://www.php.net/manual/fr/)) sont autorisés.

# Contexte

L’entreprise Ktane s’est spécialisée dans la mise au point et l’assemblage de modules de bombes explosives. Depuis plus de 7 ans, ses bombes sont utilisées un peu partout dans le monde, procurant de l’adrénaline aux équipes de démineurs qui s’y attaquent.

Dans un contexte de crise, l’entreprise a décidé d’externaliser une partie de son activité. C'est ainsi que l’implémentation des modules a été confiée à des fournisseurs qu’elle met en concurrence. A partir du manuel officiel édité par Ktane, ceux-ci doivent implémenter les modules qui seront ensuite intégrés dans chaque bombe à destination des clients.

# Mission

Afin de garantir la qualité des produit livrés à ses clients internationaux, Ktane vous a demandé de mettre au point une batterie de tests automatique des modules dans le but de détecter les implémentations non conformes et ainsi de les écarter de la ligne d’assemblage des bombes.

> Pour d’évidentes raisons de sécurité, vous ne disposez pas d’implémentation de la bombe (qui contient le sous-système d’explosion).

Plus particulièrement, vous devez implémenter une classe de tests Unitaires PHPUnit permettant de tester le module _Code Morse_ dans sa version française et correspondant au code de validation 750.

Votre classe sera utilisée pour vérifier les diverses implémentations et versions du module livrées par les prestataires. Elle doit rejeter les implémentations erronées mais également sauter les implémentations incompatibles (langue ou code de vérification).

Enfin, travaillant au sein d’une équipe, votre code produit doit respecter la norme PSR12.

# Ressources

En plus de la documentation officielle, vous disposez d’une _implémentation de référence_. Concrètement, vous disposez des fichiers suivants :

* [Le manuel de désamorçage](BombDefusalManual.pdf) au format PDF, en particulier les pages 4 (les modules) et 12 (À propos du Code Morse).
* [Une implémentation de référence](implementation/) au format TGZ contenant les éléments nécessaire à votre travail :
  * Un fichier `composer.json` pré-configuré pour dépendre de PHPUnit et configuré avec le chargeur de classes PSR4,
  * Un répertoire `classes` contenant l’interface de la bombe et l’implémentation de référence du module de Code Morse.
  * Un répertoire `tests` qui a vocation à contenir vos fichiers de test unitaire.

Une fois l’archive décompressée, vous devrez bien sûr lui ajouter l’exécutable `composer` et le lancer pour installer les dépendances (indice : `./composer.phar update`).

> En plus de PHPUnit, les dépendances contiennent les outils de qualité et métrologie de code vu en TP :
>
> * `phpcs` et `phpcbf` : permettant de contrôler la norme de style du code,
> * `phpmd` et `phpmetrics` : permettant de mesurer et détecter des codes de mauvaise qualité.
>
> Seul Code Sniffer est nécessaire, l’usage des autres outils est facultatif.

# Concrètement

## Rendu

A l’issue de votre travail, vous devez fournir une archive au format TGZ de votre répertoire `tests` contenant donc vos fichiers de tests.

Lors de l’évaluation, vos fichiers de tests seront copiés dans le répertoire `tests` des implémentations à vérifier et les tests unitaires seront lancés depuis la racine de ces projets avec cette commande :

```bash
./vendor/bin/phpunit tests
```

## Évaluation

L'évaluation du travail correspond à la qualité et l'efficacité de votre travail :

1. La capacité de vos tests à détecter des implémentations erronées,
2. Le respect des consignes du sujet sur la forme du rendu.

# A toutes fins utiles

En cas de besoin 

## Extraire et construire un fichier TGZ

Pour créer : 

```bash
tar -zcvf <votrearchive> <vos fichiers>
tar -zcvf archive.tgz tests
```

Pour extraire :

```bash
tar -zxvf <votrearchive>
tar -zxvf archive.tgz
```

## Tester le message d'une exception

Admettons que vous cherchiez à tester le message d'erreur dans cette fonction :

```php
class TrucsUtiles {
    public static function faitQuelqueChose() {
        throw new Exception("Ha ben non") ;
    }
}
```

Vous pouvez utiliser les vérifications d'exceptions de PHPUnit comme suit :

```php
class TrucsUtilesTest implements TestCase {
	public class testFaitQuelqueChose() {
        $this->expectException(Exception::class);
        $this->expectExceptionMessage("Ha ben non") ;
        
        TrucsUtiles::faitQuelqueChose() ;
    }
}
```

Vous trouverez plus de détails sur le test des exception dans [la documentation officielle](https://phpunit.readthedocs.io/fr/latest/writing-tests-for-phpunit.html#tester-des-exceptions).

## Code pénal

Puisque _nul n’est sensé ignorer la loi_ mais que personne n’est humainement capable de retenir de tête l’ensemble des lois, décrets et autres règlements, voici quelques morceaux choisis.

### Article 313-1 du code pénal

L'escroquerie est le fait, soit par l'usage d'un faux nom ou d'une  fausse qualité, soit par l'abus d'une qualité vraie, soit par l'emploi de manœuvres frauduleuses, de tromper une personne physique ou morale  et de la déterminer ainsi, à son préjudice ou au préjudice d'un tiers, à remettre des fonds, des valeurs ou un bien quelconque, à fournir un  service ou à consentir un acte opérant obligation ou décharge.

L'escroquerie est punie de cinq ans d'emprisonnement et de 375 000 euros d'amende.

### Article 121-7 du code pénal

Est complice d'un crime ou d'un délit la personne qui sciemment, par aide ou assistance, en a facilité la préparation ou la consommation.

Est également complice la personne qui par don, promesse, menace, ordre, abus d'autorité ou de pouvoir aura provoqué à une infraction ou donné des instructions pour la commettre.

